<?php
/**
 * Class for the CSF importer.
 *
 * @see https://wordpress.org/plugins/redux-framework/
 *
 * @package Merlin WP
 */

class Merlin_Csf_Importer {
	/**
	 * Import Redux data from a JSON file, generated by the Redux plugin.
	 *
	 * @param array $import_data Array of arrays. Child array contains 'option_name' and 'file_path'.
	 *
	 * @return boolean
	 */
    
    public static function import( $import_data ) {

		// CSF plugin is not active!
		if ( ! class_exists( 'CSF' ) || empty( $import_data ) ) {
			return false;
        }

        foreach ( $import_data as $import_item ) {
			$csf_options_raw_data = file_get_contents( $import_item['file_path'] );
            $csf_options_data = json_decode( ( trim( $csf_options_raw_data ) ), true );

			if ( isset( $import_item['option_name'] ) && is_array($csf_options_data) ) {
                update_option( wp_unslash( trim( $import_item['option_name'] ) ), wp_unslash( $csf_options_data ) );
				Merlin_Logger::get_instance()->debug( __( 'The CSF Framework data was imported' , '@@textdomain'), $import_item );
			}
		}

		return true;
	}
}
